from fleming.system_test.fle_sys import *

import mover_test 
import tc_test 
import bcr_test 

# >>>>>>>NOT TESTED YET<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

# 2021-04-12/Kay Struebing
# Smoke-Test Prototype 3-6 according to
# https://confluence-ext.perkinelmer.com/pages/viewpage.action?pageId=416913531
# Intention: Startup-Test after system assembly or major changes with detailed Report
#
# * Mover: mover_test.py
# * Excitation Light Sources: ex_test.py
# * Detector-Test: det_test.py
# * Flashlamp: fl_time, fl_cycle
# * TRF Laser:
# * Alpha Laser:
# * Reference Diode:
# * Absorbance Diode:
# * PMT Channel 1 & 2 :
# * Barcode Reader:
# * Temperature Control:

# Main Test with Report

# Global Constants
PATH, SCRIPT = os.path.split(__file__)
BASE_NAME = SCRIPT.split('.')[0]
ADJUSTMENT_PATH = '/home/pkiuser/.config/pyrunner/'
CONFIG_PATH = '/home/pkiuser/pyrunner/lib/python3.7/site-packages/PyRunner/config/'

async def smoke(user = 'system', comment = 'auto', mover = 1, bcr = 1 , htu_map = 1, htl_map = 1, tec = 1, pmt_1_cool = 1, pmt_2_cool = 1, tmbs = 1):
    # list of components:
    # mover, bcr, htu_map, htl_map, tec, pmt_1_cool, pmt_2_cool
    # Part 1: Mover: mover_test.py
    # Part 2: Identification: bcr_test.py
    # Part 3: Optics: optic_test.py
    #   - flashlamp
    #   - alphalasr
    #   - trflaser
    #   - ref PD
    #   - abs PD
    #   - pmt 1
    #   - pmt 2 
    # Part 4: Temperature Control: tc_test.py

    #flashlamp = 1
    #alpha_laser = 1
    #trf_laser = 1
    #ref_pd = 1
    #abs_pd = 1
    #pmt_1 = 1
    #pmt_2 = 1

    TEST_NAME = 'smoke_test'
    #test_result = {}

    time_stamp = datetime.now().strftime('%Y-%m-%d_%H-%M-%S')
    gc_out(TEST_NAME, f'started at {time_stamp}')

    # Create Reportfile with Header
    rep_filename = get_reportfile(PATH, BASE_NAME, TEST_NAME)
    pyrunner_version = py_ver()
    write_report_header(rep_filename, pyrunner_version, user, comment)

    # Initialization

    # Component-Test

    start = time.time()
    if mover > 0:
        try:
            mover_result = await mover_test.mover_loop(mover)
            write_report_record(rep_filename, mover_result)

        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))
               
    if bcr > 0:
        try:
            bcr_result = await bcr_test.bcr_test(bcr)
            write_report_record(rep_filename, bcr_result)

        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))

    # fl_result = await ex.fl_loop(10)
    # alpha_result = await ex.al_loop(10)
    # pmt_result = await ex.pmt_dark(1000)
    # ref_result = await ex.ref_pd()
    # abs_result = await ex.abs_pd()
    if htu_map > 0:
        try:
            htu_result = await tc_test.htu_test(htu_map) # Heating 1 min
            write_report_record(rep_filename, htu_result)

        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))

    if htl_map > 0:
        try:
            htl_result = await tc_test.htl_test(htl_map) # Heating 1 min
            write_report_record(rep_filename, htl_result)
        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))

    if tec > 0:
        try:
            tec_result = await tc_test.tec_test(10) # Cooling 1 min
            write_report_record(rep_filename, tec_result)
        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))

    if pmt_1_cool > 0:
        try:
            pmt1_cool_result = await tc_test.pmt1_test(1) # Cooling 1 min
            write_report_record(rep_filename, pmt1_cool_result)
        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))

    if pmt_2_cool > 0:
        try:
            pmt2_cool_result = await tc_test.pmt2_test(1) # Cooling 1 min
            write_report_record(rep_filename, pmt2_cool_result)
        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))
              
    if tmb > 1:
        try:
            tmb_result = ''
            result = await get_all_tmp()
            for r in result:
                tmb_result += f'{r}: {result[r]};'
            write_report_record(rep_filename, tmb_result)

        except Exception as ex:
            logger.error(f"gc_predefined_tasks> {traceback.format_exc()}.")
            await send_msg(json.dumps({"result": error_msg}))
                
    duration = (time.time() - start)/60.0

    msg = f">>Component Test finished, Duration: {duration:.0f} Minutes"
    gc_out(TEST_NAME, msg)
    write_report_record(rep_filename, msg)